<?php
$pageTitle = 'Gestion des Clients';
$breadcrumbs = [
    ['label' => 'Dashboard', 'url' => BASE_URL . 'index.php'],
    ['label' => 'Utilisateurs', 'url' => '#'],
    ['label' => 'Clients', 'url' => '#']
];

// Charger les données mockées
$usersData = json_decode(file_get_contents(__DIR__ . '/../../mockdata/users.json'), true);
$clients = $usersData['clients'];
$stats = $usersData['stats'];
?>

<!DOCTYPE html>
<html lang="fr" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?> | MECASOS Admin</title>
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    
    <!-- DataTables CSS -->
    <link href="https://cdn.datatables.net/1.13.7/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/buttons/2.4.2/css/buttons.bootstrap5.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/responsive/2.5.0/css/responsive.bootstrap5.min.css" rel="stylesheet">
    
    <link href="<?= ASSETS_URL ?>css/custom.css" rel="stylesheet">
    <link href="<?= ASSETS_URL ?>css/dashboard.css" rel="stylesheet">
    <link href="<?= ASSETS_URL ?>css/users.css" rel="stylesheet">
</head>
<body>

<?php include __DIR__ . '/../../includes/sidebar.php'; ?>

<div class="main-wrapper">
    <?php include __DIR__ . '/../../includes/topbar.php'; ?>
    
    <main class="main-content">
        <div class="container-fluid">
            
            <!-- Page Header -->
            <div class="page-header">
                <div class="page-header-content">
                    <h1 class="page-title">
                        <i class="bi bi-people-fill"></i>
                        Gestion des Clients
                    </h1>
                    <p class="page-subtitle">Gérez tous les clients de la plateforme MECASOS</p>
                </div>
                <div class="page-header-actions">
                    <button class="btn btn-outline-light btn-icon-text" onclick="exportData()">
                        <i class="bi bi-download"></i>
                        <span>Exporter</span>
                    </button>
                    <button class="btn btn-primary btn-icon-text" data-bs-toggle="modal" data-bs-target="#addClientModal">
                        <i class="bi bi-plus-lg"></i>
                        <span>Ajouter un client</span>
                    </button>
                </div>
            </div>

            <!-- Stats Cards Row -->
            <div class="row g-3 mb-4">
                <div class="col-xl-3 col-lg-6 col-md-6">
                    <div class="stat-card">
                        <div class="stat-icon bg-primary">
                            <i class="bi bi-people"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Total Clients</span>
                            <h3 class="stat-value"><?= number_format($stats['total']) ?></h3>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6">
                    <div class="stat-card">
                        <div class="stat-icon bg-success">
                            <i class="bi bi-check-circle"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Actifs</span>
                            <h3 class="stat-value"><?= number_format($stats['active']) ?></h3>
                            <span class="stat-percent text-success">
                                <?= number_format(($stats['active'] / $stats['total']) * 100, 1) ?>%
                            </span>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6">
                    <div class="stat-card">
                        <div class="stat-icon bg-warning">
                            <i class="bi bi-shield-check"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Vérifiés</span>
                            <h3 class="stat-value"><?= number_format($stats['verified']) ?></h3>
                            <span class="stat-percent text-warning">
                                <?= number_format(($stats['verified'] / $stats['total']) * 100, 1) ?>%
                            </span>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-lg-6 col-md-6">
                    <div class="stat-card">
                        <div class="stat-icon bg-danger">
                            <i class="bi bi-ban"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Suspendus</span>
                            <h3 class="stat-value"><?= number_format($stats['suspended']) ?></h3>
                            <span class="stat-percent text-danger">
                                <?= number_format(($stats['suspended'] / $stats['total']) * 100, 1) ?>%
                            </span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Filters & Table Card -->
            <div class="dashboard-card">
                <div class="card-header">
                    <div class="card-header-content">
                        <h5 class="card-title">
                            <i class="bi bi-table"></i>
                            Liste des Clients
                        </h5>
                    </div>
                    <div class="card-header-actions">
                        <button class="btn btn-sm btn-outline-secondary" id="refreshTable">
                            <i class="bi bi-arrow-clockwise"></i>
                            Actualiser
                        </button>
                    </div>
                </div>

                <!-- Advanced Filters -->
                <div class="card-body border-bottom">
                    <div class="advanced-filters">
                        <div class="row g-3">
                            <div class="col-lg-3 col-md-6">
                                <label class="form-label">Recherche globale</label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i class="bi bi-search"></i>
                                    </span>
                                    <input type="text" class="form-control" id="globalSearch" placeholder="Nom, email, téléphone...">
                                </div>
                            </div>
                            <div class="col-lg-2 col-md-6">
                                <label class="form-label">Statut</label>
                                <select class="form-select" id="statusFilter">
                                    <option value="">Tous</option>
                                    <option value="active">Actif</option>
                                    <option value="inactive">Inactif</option>
                                    <option value="suspended">Suspendu</option>
                                </select>
                            </div>
                            <div class="col-lg-2 col-md-6">
                                <label class="form-label">Vérification</label>
                                <select class="form-select" id="verificationFilter">
                                    <option value="">Tous</option>
                                    <option value="verified">Vérifié</option>
                                    <option value="pending">En attente</option>
                                </select>
                            </div>
                            <div class="col-lg-3 col-md-6">
                                <label class="form-label">Période d'inscription</label>
                                <input type="text" class="form-control" id="dateRangePicker" placeholder="Sélectionner une période">
                            </div>
                            <div class="col-lg-2 col-md-12">
                                <label class="form-label">&nbsp;</label>
                                <button class="btn btn-outline-secondary w-100" id="resetFilters">
                                    <i class="bi bi-x-circle"></i>
                                    Réinitialiser
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Actions en masse -->
                <div class="card-body border-bottom" id="bulkActionsBar" style="display: none;">
                    <div class="bulk-actions-bar">
                        <div class="selected-count">
                            <i class="bi bi-check-square"></i>
                            <span id="selectedCount">0</span> client(s) sélectionné(s)
                        </div>
                        <div class="bulk-actions">
                            <button class="btn btn-sm btn-success" onclick="bulkAction('activate')">
                                <i class="bi bi-check-circle"></i>
                                Activer
                            </button>
                            <button class="btn btn-sm btn-warning" onclick="bulkAction('deactivate')">
                                <i class="bi bi-pause-circle"></i>
                                Désactiver
                            </button>
                            <button class="btn btn-sm btn-danger" onclick="bulkAction('suspend')">
                                <i class="bi bi-ban"></i>
                                Suspendre
                            </button>
                            <button class="btn btn-sm btn-primary" onclick="bulkAction('export')">
                                <i class="bi bi-download"></i>
                                Exporter sélection
                            </button>
                        </div>
                    </div>
                </div>

                <!-- DataTable -->
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table id="clientsTable" class="table table-hover users-table" style="width:100%">
                            <thead>
                                <tr>
                                    <th>
                                        <input type="checkbox" class="form-check-input" id="selectAll">
                                    </th>
                                    <th>ID</th>
                                    <th>Client</th>
                                    <th>Contact</th>
                                    <th>Statut</th>
                                    <th>Vérification</th>
                                    <th>Interventions</th>
                                    <th>Dépenses</th>
                                    <th>Wallet</th>
                                    <th>Note</th>
                                    <th>Inscription</th>
                                    <th>Dernière activité</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($clients as $client): ?>
                                <tr data-client-id="<?= $client['id'] ?>">
                                    <td>
                                        <input type="checkbox" class="form-check-input row-checkbox" value="<?= $client['id'] ?>">
                                    </td>
                                    <td>
                                        <span class="badge bg-dark">#<?= str_pad($client['id'], 4, '0', STR_PAD_LEFT) ?></span>
                                    </td>
                                    <td>
                                        <div class="user-cell">
                                            <img src="<?= getDefaultAvatar($client['name']) ?>" alt="" class="user-avatar">
                                            <div class="user-info">
                                                <span class="user-name"><?= e($client['name']) ?></span>
                                                <span class="user-location">
                                                    <i class="bi bi-geo-alt"></i>
                                                    <?= e($client['location']) ?>
                                                </span>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="contact-info">
                                            <div class="contact-item">
                                                <i class="bi bi-envelope"></i>
                                                <span><?= e($client['email']) ?></span>
                                            </div>
                                            <div class="contact-item">
                                                <i class="bi bi-phone"></i>
                                                <span><?= e($client['phone']) ?></span>
                                            </div>
                                        </div>
                                    </td>
                                    <td><?= getStatusBadge($client['status']) ?></td>
                                    <td><?= getVerificationBadge($client['verification_status']) ?></td>
                                    <td>
                                        <span class="badge bg-info"><?= $client['total_interventions'] ?></span>
                                    </td>
                                    <td>
                                        <strong class="text-gold"><?= formatCurrency($client['total_spent']) ?></strong>
                                    </td>
                                    <td>
                                        <span class="wallet-badge">
                                            <i class="bi bi-wallet2"></i>
                                            <?= formatCurrency($client['wallet_balance']) ?>
                                        </span>
                                    </td>
                                    <td>
                                        <div class="rating-display">
                                            <i class="bi bi-star-fill text-warning"></i>
                                            <span><?= $client['rating'] ?></span>
                                        </div>
                                    </td>
                                    <td>
                                        <small class="text-muted"><?= formatDate($client['registration_date'], 'd/m/Y') ?></small>
                                    </td>
                                    <td>
                                        <small class="text-muted">
                                            <i class="bi bi-clock"></i>
                                            <?= timeAgo($client['last_login']) ?>
                                        </small>
                                    </td>
                                    <td>
                                        <div class="action-buttons">
                                            <button class="btn btn-sm btn-icon btn-primary" 
                                                    onclick="viewClient(<?= $client['id'] ?>)" 
                                                    title="Voir détails">
                                                <i class="bi bi-eye"></i>
                                            </button>
                                            <button class="btn btn-sm btn-icon btn-success" 
                                                    onclick="editClient(<?= $client['id'] ?>)" 
                                                    title="Modifier">
                                                <i class="bi bi-pencil"></i>
                                            </button>
                                            <div class="btn-group">
                                                <button class="btn btn-sm btn-icon btn-secondary dropdown-toggle" 
                                                        data-bs-toggle="dropdown" 
                                                        title="Plus d'actions">
                                                    <i class="bi bi-three-dots-vertical"></i>
                                                </button>
                                                <ul class="dropdown-menu dropdown-menu-dark dropdown-menu-end">
                                                    <li>
                                                        <a class="dropdown-item" href="#" onclick="sendNotification(<?= $client['id'] ?>)">
                                                            <i class="bi bi-send"></i> Envoyer notification
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#" onclick="viewHistory(<?= $client['id'] ?>)">
                                                            <i class="bi bi-clock-history"></i> Voir historique
                                                        </a>
                                                    </li>
                                                    <li>
                                                        <a class="dropdown-item" href="#" onclick="manageWallet(<?= $client['id'] ?>)">
                                                            <i class="bi bi-wallet2"></i> Gérer wallet
                                                        </a>
                                                    </li>
                                                    <li><hr class="dropdown-divider"></li>
                                                    <?php if($client['status'] === 'active'): ?>
                                                    <li>
                                                        <a class="dropdown-item text-warning" href="#" onclick="suspendClient(<?= $client['id'] ?>)">
                                                            <i class="bi bi-ban"></i> Suspendre
                                                        </a>
                                                    </li>
                                                    <?php else: ?>
                                                    <li>
                                                        <a class="dropdown-item text-success" href="#" onclick="activateClient(<?= $client['id'] ?>)">
                                                            <i class="bi bi-check-circle"></i> Activer
                                                        </a>
                                                    </li>
                                                    <?php endif; ?>
                                                    <li>
                                                        <a class="dropdown-item text-danger" href="#" onclick="deleteClient(<?= $client['id'] ?>)">
                                                            <i class="bi bi-trash"></i> Supprimer
                                                        </a>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </main>
    
    <?php include __DIR__ . '/../../includes/footer.php'; ?>
</div>

<!-- Modal: View Client Details -->
<div class="modal fade" id="viewClientModal" tabindex="-1">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="bi bi-person-circle"></i>
                    Détails du Client
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body" id="clientDetailsContent">
                <!-- Contenu chargé dynamiquement -->
                <div class="text-center py-5">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Chargement...</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal: Add Client -->
<div class="modal fade" id="addClientModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="bi bi-person-plus"></i>
                    Ajouter un Nouveau Client
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form id="addClientForm">
                <div class="modal-body">
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label class="form-label">Nom complet *</label>
                            <input type="text" class="form-control" name="name" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Email *</label>
                            <input type="email" class="form-control" name="email" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Téléphone *</label>
                            <input type="tel" class="form-control" name="phone" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Localisation</label>
                            <input type="text" class="form-control" name="location" placeholder="Ville, Quartier">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Mot de passe *</label>
                            <input type="password" class="form-control" name="password" required>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Confirmer mot de passe *</label>
                            <input type="password" class="form-control" name="password_confirm" required>
                        </div>
                        <div class="col-12">
                            <hr class="my-3">
                            <h6 class="mb-3">Véhicule (Optionnel)</h6>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Marque</label>
                            <input type="text" class="form-control" name="vehicle_brand">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Modèle</label>
                            <input type="text" class="form-control" name="vehicle_model">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Année</label>
                            <input type="number" class="form-control" name="vehicle_year" min="1900" max="2025">
                        </div>
                        <div class="col-md-6">
                            <label class="form-label">Immatriculation</label>
                            <input type="text" class="form-control" name="vehicle_plate" placeholder="CE-1234-XX">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-lg"></i>
                        Créer le client
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>

<!-- DataTables -->
<script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.7/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.bootstrap5.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/dataTables.responsive.min.js"></script>
<script src="https://cdn.datatables.net/responsive/2.5.0/js/responsive.bootstrap5.min.js"></script>

<script src="<?= ASSETS_URL ?>js/main.js"></script>
<script src="<?= ASSETS_URL ?>js/users.js"></script>

</body>
</html>

<?php
// Fonction helper pour badge de vérification
function getVerificationBadge($status) {
    $badges = [
        'verified' => '<span class="badge bg-success"><i class="bi bi-shield-check"></i> Vérifié</span>',
        'pending' => '<span class="badge bg-warning"><i class="bi bi-hourglass-split"></i> En attente</span>',
        'rejected' => '<span class="badge bg-danger"><i class="bi bi-x-circle"></i> Rejeté</span>',
    ];
    return $badges[$status] ?? '<span class="badge bg-secondary">Inconnu</span>';
}
?>