<?php
$pageTitle = 'Paramètres Système';
$breadcrumbs = [
    ['label' => 'Dashboard', 'url' => '../index.php'],
    ['label' => 'Paramètres', 'url' => '#']
];

require_once __DIR__ . '/../../config/constants.php';
require_once __DIR__ . '/../../config/functions.php';

// Current settings (simulated - in real app would come from database)
$currentSettings = [
    'general' => [
        'app_name' => 'MECASOS',
        'app_description' => 'Assistance routière 24/7 au Cameroun',
        'contact_email' => 'support@mecasos.com',
        'contact_phone' => '+237 690 123 456',
        'support_phone' => '+237 677 234 567',
        'maintenance_mode' => false,
        'maintenance_message' => 'Service temporairement indisponible pour maintenance.',
        'timezone' => 'Africa/Lome',
        'language' => 'fr'
    ],
    'payments' => [
        'commission_rate' => 15.0,
        'min_commission' => 1000,
        'max_commission' => 50000,
        'currency' => 'XAF',
        'payment_methods' => ['wallet', 'card', 'cash'],
        'auto_payout' => true,
        'payout_schedule' => 'weekly',
        'min_payout_amount' => 5000,
        'processing_fee' => 2.5
    ],
    'notifications' => [
        'email_enabled' => true,
        'sms_enabled' => true,
        'push_enabled' => true,
        'email_templates' => [
            'welcome' => true,
            'intervention_assigned' => true,
            'payment_received' => true,
            'review_received' => true
        ],
        'sms_templates' => [
            'intervention_started' => true,
            'mechanic_arrived' => true,
            'service_completed' => true
        ],
        'push_templates' => [
            'new_intervention' => true,
            'status_update' => true,
            'payment_notification' => true
        ]
    ],
    'security' => [
        'password_min_length' => 8,
        'password_require_uppercase' => true,
        'password_require_numbers' => true,
        'password_require_symbols' => false,
        'session_timeout' => 3600,
        'max_login_attempts' => 5,
        'lockout_duration' => 900,
        'api_rate_limit' => 1000,
        'api_key_expiry' => 365,
        'two_factor_required' => false
    ],
    'appearance' => [
        'theme' => 'dark',
        'primary_color' => '#E1A004',
        'secondary_color' => '#1D1D1B',
        'logo_url' => '/assets/img/logo.png',
        'favicon_url' => '/assets/img/favicon.png',
        'font_family' => 'Poppins',
        'border_radius' => '8px',
        'sidebar_collapsed' => false
    ]
];
?>

<!-- Page Header -->
<div class="page-header">
    <div class="page-header-content">
        <h1 class="page-title">
            <i class="bi bi-gear"></i>
            Paramètres Système
        </h1>
        <p class="page-subtitle">Configuration générale de la plateforme MECASOS</p>
    </div>
    <div class="page-header-actions">
        <button class="btn btn-outline-secondary btn-icon-text" onclick="resetToDefaults()">
            <i class="bi bi-arrow-counterclockwise"></i>
            <span>Réinitialiser</span>
        </button>
        <button class="btn btn-primary btn-icon-text" onclick="saveAllSettings()">
            <i class="bi bi-check-lg"></i>
            <span>Sauvegarder tout</span>
        </button>
    </div>
</div>

<!-- Settings Tabs -->
<div class="settings-container">
    <div class="settings-sidebar">
        <nav class="settings-nav">
            <a href="#general" class="nav-item active" data-tab="general">
                <i class="bi bi-info-circle"></i>
                <span>Général</span>
            </a>
            <a href="#payments" class="nav-item" data-tab="payments">
                <i class="bi bi-credit-card"></i>
                <span>Paiements</span>
            </a>
            <a href="#notifications" class="nav-item" data-tab="notifications">
                <i class="bi bi-bell"></i>
                <span>Notifications</span>
            </a>
            <a href="#security" class="nav-item" data-tab="security">
                <i class="bi bi-shield-lock"></i>
                <span>Sécurité</span>
            </a>
            <a href="#appearance" class="nav-item" data-tab="appearance">
                <i class="bi bi-palette"></i>
                <span>Apparence</span>
            </a>
        </nav>
    </div>

    <div class="settings-content">
        <!-- General Tab -->
        <div id="general" class="settings-tab active">
            <div class="tab-header">
                <h3>Paramètres Généraux</h3>
                <p>Informations de base et configuration générale de l'application</p>
            </div>

            <div class="settings-section">
                <h4>Informations de l'application</h4>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Nom de l'application</label>
                        <input type="text" class="form-control" name="app_name" value="<?= e($currentSettings['general']['app_name']) ?>">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Fuseau horaire</label>
                        <select class="form-select" name="timezone">
                            <option value="Africa/Lome" <?= $currentSettings['general']['timezone'] === 'Africa/Lome' ? 'selected' : '' ?>>Afrique/Lome (UTC+0)</option>
                            <option value="Africa/Douala">Afrique/Douala (UTC+1)</option>
                            <option value="UTC">UTC</option>
                        </select>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" name="app_description" rows="2"><?= e($currentSettings['general']['app_description']) ?></textarea>
                    </div>
                </div>
            </div>

            <div class="settings-section">
                <h4>Informations de contact</h4>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Email de contact</label>
                        <input type="email" class="form-control" name="contact_email" value="<?= e($currentSettings['general']['contact_email']) ?>">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Téléphone principal</label>
                        <input type="tel" class="form-control" name="contact_phone" value="<?= e($currentSettings['general']['contact_phone']) ?>">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Téléphone support</label>
                        <input type="tel" class="form-control" name="support_phone" value="<?= e($currentSettings['general']['support_phone']) ?>">
                    </div>
                </div>
            </div>

            <div class="settings-section">
                <h4>Maintenance</h4>
                <div class="row g-3">
                    <div class="col-12">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="maintenance_mode" <?= $currentSettings['general']['maintenance_mode'] ? 'checked' : '' ?>>
                            <label class="form-check-label">Mode maintenance activé</label>
                        </div>
                        <small class="text-muted">Quand activé, l'application sera inaccessible aux utilisateurs</small>
                    </div>
                    <div class="col-12">
                        <label class="form-label">Message de maintenance</label>
                        <textarea class="form-control" name="maintenance_message" rows="2"><?= e($currentSettings['general']['maintenance_message']) ?></textarea>
                    </div>
                </div>
            </div>
        </div>

        <!-- Payments Tab -->
        <div id="payments" class="settings-tab">
            <div class="tab-header">
                <h3>Paramètres de Paiement</h3>
                <p>Configuration des commissions et méthodes de paiement</p>
            </div>

            <div class="settings-section">
                <h4>Commissions</h4>
                <div class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Taux de commission (%)</label>
                        <input type="number" class="form-control" name="commission_rate" value="<?= $currentSettings['payments']['commission_rate'] ?>" step="0.1" min="0" max="50">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Commission minimum (FCFA)</label>
                        <input type="number" class="form-control" name="min_commission" value="<?= $currentSettings['payments']['min_commission'] ?>" min="0">
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Commission maximum (FCFA)</label>
                        <input type="number" class="form-control" name="max_commission" value="<?= $currentSettings['payments']['max_commission'] ?>" min="0">
                    </div>
                </div>
            </div>

            <div class="settings-section">
                <h4>Méthodes de paiement</h4>
                <div class="row g-3">
                    <div class="col-12">
                        <label class="form-label">Méthodes acceptées</label>
                        <div class="payment-methods">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="payment_wallet" <?= in_array('wallet', $currentSettings['payments']['payment_methods']) ? 'checked' : '' ?>>
                                <label class="form-check-label">Portefeuille MECASOS</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="payment_card" <?= in_array('card', $currentSettings['payments']['payment_methods']) ? 'checked' : '' ?>>
                                <label class="form-check-label">Carte bancaire</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="payment_cash" <?= in_array('cash', $currentSettings['payments']['payment_methods']) ? 'checked' : '' ?>>
                                <label class="form-check-label">Espèces</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="settings-section">
                <h4>Versements automatiques</h4>
                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="auto_payout" <?= $currentSettings['payments']['auto_payout'] ? 'checked' : '' ?>>
                            <label class="form-check-label">Versements automatiques activés</label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Fréquence de versement</label>
                        <select class="form-select" name="payout_schedule">
                            <option value="daily" <?= $currentSettings['payments']['payout_schedule'] === 'daily' ? 'selected' : '' ?>>Quotidien</option>
                            <option value="weekly" <?= $currentSettings['payments']['payout_schedule'] === 'weekly' ? 'selected' : '' ?>>Hebdomadaire</option>
                            <option value="monthly" <?= $currentSettings['payments']['payout_schedule'] === 'monthly' ? 'selected' : '' ?>>Mensuel</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Montant minimum de versement (FCFA)</label>
                        <input type="number" class="form-control" name="min_payout_amount" value="<?= $currentSettings['payments']['min_payout_amount'] ?>" min="0">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Frais de traitement (%)</label>
                        <input type="number" class="form-control" name="processing_fee" value="<?= $currentSettings['payments']['processing_fee'] ?>" step="0.1" min="0" max="10">
                    </div>
                </div>
            </div>
        </div>

        <!-- Notifications Tab -->
        <div id="notifications" class="settings-tab">
            <div class="tab-header">
                <h3>Paramètres de Notifications</h3>
                <p>Configuration des emails, SMS et notifications push</p>
            </div>

            <div class="settings-section">
                <h4>Canaux de notification</h4>
                <div class="row g-3">
                    <div class="col-md-4">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="email_enabled" <?= $currentSettings['notifications']['email_enabled'] ? 'checked' : '' ?>>
                            <label class="form-check-label">Emails activés</label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="sms_enabled" <?= $currentSettings['notifications']['sms_enabled'] ? 'checked' : '' ?>>
                            <label class="form-check-label">SMS activés</label>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="push_enabled" <?= $currentSettings['notifications']['push_enabled'] ? 'checked' : '' ?>>
                            <label class="form-check-label">Notifications push activées</label>
                        </div>
                    </div>
                </div>
            </div>

            <div class="settings-section">
                <h4>Templates Email</h4>
                <div class="notification-templates">
                    <div class="template-item">
                        <div class="template-info">
                            <span class="template-name">Email de bienvenue</span>
                            <small class="template-desc">Envoyé lors de l'inscription</small>
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="email_welcome" <?= $currentSettings['notifications']['email_templates']['welcome'] ? 'checked' : '' ?>>
                        </div>
                    </div>
                    <div class="template-item">
                        <div class="template-info">
                            <span class="template-name">Intervention assignée</span>
                            <small class="template-desc">Notification d'assignation à un mécanicien</small>
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="email_intervention_assigned" <?= $currentSettings['notifications']['email_templates']['intervention_assigned'] ? 'checked' : '' ?>>
                        </div>
                    </div>
                    <div class="template-item">
                        <div class="template-info">
                            <span class="template-name">Paiement reçu</span>
                            <small class="template-desc">Confirmation de paiement</small>
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="email_payment_received" <?= $currentSettings['notifications']['email_templates']['payment_received'] ? 'checked' : '' ?>>
                        </div>
                    </div>
                </div>
            </div>

            <div class="settings-section">
                <h4>Templates SMS</h4>
                <div class="notification-templates">
                    <div class="template-item">
                        <div class="template-info">
                            <span class="template-name">Intervention démarrée</span>
                            <small class="template-desc">Mécanicien en route</small>
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="sms_intervention_started" <?= $currentSettings['notifications']['sms_templates']['intervention_started'] ? 'checked' : '' ?>>
                        </div>
                    </div>
                    <div class="template-item">
                        <div class="template-info">
                            <span class="template-name">Mécanicien arrivé</span>
                            <small class="template-desc">Arrivée sur place</small>
                        </div>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="sms_mechanic_arrived" <?= $currentSettings['notifications']['sms_templates']['mechanic_arrived'] ? 'checked' : '' ?>>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Security Tab -->
        <div id="security" class="settings-tab">
            <div class="tab-header">
                <h3>Paramètres de Sécurité</h3>
                <p>Politiques de mots de passe et protection des comptes</p>
            </div>

            <div class="settings-section">
                <h4>Politique des mots de passe</h4>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Longueur minimum</label>
                        <input type="number" class="form-control" name="password_min_length" value="<?= $currentSettings['security']['password_min_length'] ?>" min="6" max="32">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Timeout de session (minutes)</label>
                        <input type="number" class="form-control" name="session_timeout" value="<?= $currentSettings['security']['session_timeout'] / 60 ?>" min="5" max="480">
                    </div>
                    <div class="col-12">
                        <label class="form-label">Exigences des mots de passe</label>
                        <div class="password-requirements">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="password_require_uppercase" <?= $currentSettings['security']['password_require_uppercase'] ? 'checked' : '' ?>>
                                <label class="form-check-label">Au moins une majuscule</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="password_require_numbers" <?= $currentSettings['security']['password_require_numbers'] ? 'checked' : '' ?>>
                                <label class="form-check-label">Au moins un chiffre</label>
                            </div>
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" name="password_require_symbols" <?= $currentSettings['security']['password_require_symbols'] ? 'checked' : '' ?>>
                                <label class="form-check-label">Au moins un symbole</label>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="settings-section">
                <h4>Protection contre les attaques</h4>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Tentatives de connexion max</label>
                        <input type="number" class="form-control" name="max_login_attempts" value="<?= $currentSettings['security']['max_login_attempts'] ?>" min="3" max="10">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Durée de blocage (minutes)</label>
                        <input type="number" class="form-control" name="lockout_duration" value="<?= $currentSettings['security']['lockout_duration'] / 60 ?>" min="5" max="60">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Limite API (requêtes/heure)</label>
                        <input type="number" class="form-control" name="api_rate_limit" value="<?= $currentSettings['security']['api_rate_limit'] ?>" min="100" max="10000">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Expiration des clés API (jours)</label>
                        <input type="number" class="form-control" name="api_key_expiry" value="<?= $currentSettings['security']['api_key_expiry'] ?>" min="30" max="365">
                    </div>
                </div>
            </div>

            <div class="settings-section">
                <h4>Authentification à deux facteurs</h4>
                <div class="row g-3">
                    <div class="col-12">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="two_factor_required" <?= $currentSettings['security']['two_factor_required'] ? 'checked' : '' ?>>
                            <label class="form-check-label">2FA obligatoire pour tous les comptes</label>
                        </div>
                        <small class="text-muted">Recommandé pour les comptes administrateur</small>
                    </div>
                </div>
            </div>
        </div>

        <!-- Appearance Tab -->
        <div id="appearance" class="settings-tab">
            <div class="tab-header">
                <h3>Paramètres d'Apparence</h3>
                <p>Personnalisation du thème et de l'interface</p>
            </div>

            <div class="settings-section">
                <h4>Thème et couleurs</h4>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Thème</label>
                        <select class="form-select" name="theme">
                            <option value="dark" <?= $currentSettings['appearance']['theme'] === 'dark' ? 'selected' : '' ?>>Sombre</option>
                            <option value="light" <?= $currentSettings['appearance']['theme'] === 'light' ? 'selected' : '' ?>>Clair</option>
                            <option value="auto">Automatique</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Police</label>
                        <select class="form-select" name="font_family">
                            <option value="Poppins" <?= $currentSettings['appearance']['font_family'] === 'Poppins' ? 'selected' : '' ?>>Poppins</option>
                            <option value="Inter" <?= $currentSettings['appearance']['font_family'] === 'Inter' ? 'selected' : '' ?>>Inter</option>
                            <option value="Roboto">Roboto</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Couleur primaire</label>
                        <input type="color" class="form-control" name="primary_color" value="<?= $currentSettings['appearance']['primary_color'] ?>">
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Couleur secondaire</label>
                        <input type="color" class="form-control" name="secondary_color" value="<?= $currentSettings['appearance']['secondary_color'] ?>">
                    </div>
                </div>
            </div>

            <div class="settings-section">
                <h4>Images et logos</h4>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Logo principal</label>
                        <input type="file" class="form-control" name="logo" accept="image/*">
                        <small class="text-muted">Format recommandé: PNG, 200x60px</small>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label">Favicon</label>
                        <input type="file" class="form-control" name="favicon" accept="image/*">
                        <small class="text-muted">Format recommandé: ICO ou PNG, 32x32px</small>
                    </div>
                </div>
            </div>

            <div class="settings-section">
                <h4>Interface</h4>
                <div class="row g-3">
                    <div class="col-md-6">
                        <label class="form-label">Rayon des bordures</label>
                        <select class="form-select" name="border_radius">
                            <option value="0px" <?= $currentSettings['appearance']['border_radius'] === '0px' ? 'selected' : '' ?>>Carré</option>
                            <option value="4px" <?= $currentSettings['appearance']['border_radius'] === '4px' ? 'selected' : '' ?>>Léger</option>
                            <option value="8px" <?= $currentSettings['appearance']['border_radius'] === '8px' ? 'selected' : '' ?>>Moyen</option>
                            <option value="12px">Arrondi</option>
                            <option value="20px">Très arrondi</option>
                        </select>
                    </div>
                    <div class="col-md-6">
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="sidebar_collapsed" <?= $currentSettings['appearance']['sidebar_collapsed'] ? 'checked' : '' ?>>
                            <label class="form-check-label">Barre latérale réduite par défaut</label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// ========================================
// SETTINGS FUNCTIONALITY
// ========================================
document.addEventListener('DOMContentLoaded', function() {
    // Tab navigation
    const navItems = document.querySelectorAll('.settings-nav .nav-item');
    const tabs = document.querySelectorAll('.settings-tab');

    navItems.forEach(item => {
        item.addEventListener('click', function(e) {
            e.preventDefault();
            const tabId = this.getAttribute('data-tab');

            // Remove active class from all items
            navItems.forEach(nav => nav.classList.remove('active'));
            tabs.forEach(tab => tab.classList.remove('active'));

            // Add active class to clicked item and corresponding tab
            this.classList.add('active');
            document.getElementById(tabId).classList.add('active');
        });
    });

    // Auto-save on input change (debounced)
    let saveTimeout;
    document.querySelectorAll('input, select, textarea').forEach(input => {
        input.addEventListener('input', function() {
            clearTimeout(saveTimeout);
            saveTimeout = setTimeout(() => {
                autoSaveSetting(this.name, this.value, this.type === 'checkbox' ? this.checked : this.value);
            }, 1000);
        });
    });
});

// Functions
function saveAllSettings() {
    showNotification('Sauvegarde de tous les paramètres...', 'info');
    setTimeout(() => {
        showNotification('Paramètres sauvegardés avec succès!', 'success');
    }, 2000);
}

function resetToDefaults() {
    if (confirm('Êtes-vous sûr de vouloir réinitialiser tous les paramètres aux valeurs par défaut? Cette action est irréversible.')) {
        showNotification('Paramètres réinitialisés', 'warning');
    }
}

function autoSaveSetting(name, value, checked = null) {
    const actualValue = checked !== null ? checked : value;
    console.log('Auto-saving:', name, actualValue);
    // In real implementation, this would send to server
}

function showNotification(message, type = 'info') {
    const notification = document.createElement('div');
    notification.className = `alert alert-${type} alert-dismissible fade show position-fixed`;
    notification.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    notification.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;

    document.body.appendChild(notification);

    setTimeout(() => {
        if(notification.parentNode) {
            notification.remove();
        }
    }, 5000);
}
</script>

<style>
/* Settings Layout */
.settings-container {
    display: flex;
    gap: 30px;
    margin-top: 24px;
}

.settings-sidebar {
    width: 250px;
    flex-shrink: 0;
}

.settings-nav {
    background: var(--card-background);
    border: 1px solid var(--border-color);
    border-radius: 12px;
    overflow: hidden;
}

.settings-nav .nav-item {
    display: flex;
    align-items: center;
    gap: 12px;
    padding: 16px 20px;
    color: var(--text-secondary);
    text-decoration: none;
    border-bottom: 1px solid rgba(255, 255, 255, 0.05);
    transition: all 0.2s ease;
}

.settings-nav .nav-item:hover {
    background: rgba(255, 255, 255, 0.02);
    color: var(--text-primary);
}

.settings-nav .nav-item.active {
    background: var(--primary-color);
    color: white;
    border-bottom-color: var(--primary-color);
}

.settings-nav .nav-item:last-child {
    border-bottom: none;
}

.settings-nav .nav-item i {
    font-size: 18px;
    width: 20px;
}

.settings-content {
    flex: 1;
}

.settings-tab {
    display: none;
}

.settings-tab.active {
    display: block;
}

.tab-header {
    margin-bottom: 32px;
}

.tab-header h3 {
    margin: 0 0 8px 0;
    color: var(--text-primary);
    font-size: 24px;
    font-weight: 600;
}

.tab-header p {
    margin: 0;
    color: var(--text-secondary);
}

/* Settings Sections */
.settings-section {
    background: var(--card-background);
    border: 1px solid var(--border-color);
    border-radius: 12px;
    padding: 24px;
    margin-bottom: 24px;
}

.settings-section h4 {
    margin: 0 0 20px 0;
    color: var(--text-primary);
    font-size: 18px;
    font-weight: 600;
}

.settings-section .row {
    margin-bottom: 0;
}

.settings-section .form-label {
    font-weight: 500;
    color: var(--text-primary);
    margin-bottom: 8px;
}

.settings-section .form-control,
.settings-section .form-select {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid var(--border-color);
    color: var(--text-primary);
    padding: 10px 16px;
    border-radius: 8px;
}

.settings-section .form-control:focus,
.settings-section .form-select:focus {
    background: rgba(255, 255, 255, 0.05);
    border-color: var(--primary-color);
    color: var(--text-primary);
    box-shadow: 0 0 0 0.2rem rgba(225, 160, 4, 0.25);
}

/* Payment Methods */
.payment-methods {
    display: flex;
    flex-direction: column;
    gap: 12px;
}

.payment-methods .form-check {
    margin: 0;
}

/* Notification Templates */
.notification-templates {
    display: flex;
    flex-direction: column;
    gap: 16px;
}

.template-item {
    display: flex;
    align-items: center;
    justify-content: space-between;
    padding: 16px;
    background: rgba(255, 255, 255, 0.02);
    border-radius: 8px;
}

.template-info {
    display: flex;
    flex-direction: column;
}

.template-name {
    font-weight: 500;
    color: var(--text-primary);
}

.template-desc {
    font-size: 12px;
    color: var(--text-secondary);
}

/* Password Requirements */
.password-requirements {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 12px;
}

.password-requirements .form-check {
    margin: 0;
}

/* Responsive */
@media (max-width: 768px) {
    .settings-container {
        flex-direction: column;
        gap: 20px;
    }

    .settings-sidebar {
        width: 100%;
    }

    .settings-nav {
        display: flex;
        overflow-x: auto;
    }

    .settings-nav .nav-item {
        flex-shrink: 0;
        border-bottom: none;
        border-right: 1px solid rgba(255, 255, 255, 0.05);
    }

    .settings-nav .nav-item:last-child {
        border-right: none;
    }

    .settings-section {
        padding: 16px;
    }

    .template-item {
        flex-direction: column;
        gap: 12px;
        text-align: center;
    }

    .password-requirements {
        grid-template-columns: 1fr;
    }
}
</style>