<?php
$pageTitle = 'Tableau de bord';
$breadcrumbs = [
    ['label' => 'Dashboard', 'url' => '#']
];

require_once __DIR__ . '/../config/constants.php';
require_once __DIR__ . '/../config/functions.php';

// Charger les mock data
$statsData = json_decode(file_get_contents(__DIR__ . '/../mockdata/stats.json'), true);
$overview = $statsData['overview'];
$recentInterventions = $statsData['recent_interventions'];
$revenueChart = $statsData['revenue_chart'];
$topMechanics = $statsData['top_mechanics'];

// Simuler les notifications (mockdata)
$pendingVerifications = 5;
$activeInterventions = 23;
$newMessages = 12;
?>

<!-- Page Header -->
<div class="page-header">
    <div class="page-header-content">
        <h1 class="page-title">
            <i class="bi bi-grid-fill"></i>
            Tableau de bord
        </h1>
        <p class="page-subtitle">Vue d'ensemble de votre plateforme MECASOS</p>
    </div>
    <div class="page-header-actions">
        <button class="btn btn-outline-light btn-icon-text">
            <i class="bi bi-calendar3"></i>
            <span>Aujourd'hui : <?= date('d/m/Y') ?></span>
        </button>
        <button class="btn btn-primary btn-icon-text" data-bs-toggle="modal" data-bs-target="#quickActionsModal">
            <i class="bi bi-plus-lg"></i>
            <span>Actions rapides</span>
        </button>
    </div>
</div>

<!-- KPI Cards Row -->
<div class="row g-4 mb-4">
    <!-- Total Users -->
    <div class="col-xl-3 col-lg-6 col-md-6">
        <div class="kpi-card" data-aos="fade-up" data-aos-delay="0">
            <div class="kpi-card-body">
                <div class="kpi-icon bg-gradient-primary">
                    <i class="bi bi-people-fill"></i>
                </div>
                <div class="kpi-content">
                    <span class="kpi-label">Total Utilisateurs</span>
                    <h3 class="kpi-value">
                        <span class="counter" data-target="<?= $overview['total_users'] ?>">0</span>
                    </h3>
                    <div class="kpi-trend trend-up">
                        <i class="bi bi-arrow-up"></i>
                        <span><?= number_format($overview['growth']['users'], 1) ?>%</span>
                        <small>vs mois dernier</small>
                    </div>
                </div>
            </div>
            <div class="kpi-footer">
                <a href="pages/users/clients.php" class="kpi-link">
                    Voir détails <i class="bi bi-arrow-right"></i>
                </a>
            </div>
        </div>
    </div>

    <!-- Total Mechanics -->
    <div class="col-xl-3 col-lg-6 col-md-6">
        <div class="kpi-card" data-aos="fade-up" data-aos-delay="100">
            <div class="kpi-card-body">
                <div class="kpi-icon bg-gradient-success">
                    <i class="bi bi-wrench"></i>
                </div>
                <div class="kpi-content">
                    <span class="kpi-label">Mécaniciens Actifs</span>
                    <h3 class="kpi-value">
                        <span class="counter" data-target="<?= $overview['total_mechanics'] ?>">0</span>
                    </h3>
                    <div class="kpi-trend trend-up">
                        <i class="bi bi-arrow-up"></i>
                        <span><?= number_format($overview['growth']['mechanics'], 1) ?>%</span>
                        <small>vs mois dernier</small>
                    </div>
                </div>
            </div>
            <div class="kpi-footer">
                <a href="pages/users/mechanics.php" class="kpi-link">
                    Voir détails <i class="bi bi-arrow-right"></i>
                </a>
            </div>
        </div>
    </div>

    <!-- Active Interventions -->
    <div class="col-xl-3 col-lg-6 col-md-6">
        <div class="kpi-card" data-aos="fade-up" data-aos-delay="200">
            <div class="kpi-card-body">
                <div class="kpi-icon bg-gradient-warning">
                    <i class="bi bi-tools"></i>
                </div>
                <div class="kpi-content">
                    <span class="kpi-label">Interventions en Cours</span>
                    <h3 class="kpi-value">
                        <span class="counter" data-target="<?= $overview['active_interventions'] ?>">0</span>
                    </h3>
                    <div class="kpi-trend trend-down">
                        <i class="bi bi-arrow-down"></i>
                        <span><?= number_format(abs($overview['growth']['interventions']), 1) ?>%</span>
                        <small>vs mois dernier</small>
                    </div>
                </div>
            </div>
            <div class="kpi-footer">
                <a href="pages/interventions/active.php" class="kpi-link">
                    Voir détails <i class="bi bi-arrow-right"></i>
                </a>
            </div>
        </div>
    </div>

    <!-- Monthly Revenue -->
    <div class="col-xl-3 col-lg-6 col-md-6">
        <div class="kpi-card" data-aos="fade-up" data-aos-delay="300">
            <div class="kpi-card-body">
                <div class="kpi-icon bg-gradient-gold">
                    <i class="bi bi-currency-dollar"></i>
                </div>
                <div class="kpi-content">
                    <span class="kpi-label">Revenus du Mois</span>
                    <h3 class="kpi-value">
                        <span class="counter" data-target="<?= $overview['monthly_revenue'] ?>">0</span>
                        <small> FCFA</small>
                    </h3>
                    <div class="kpi-trend trend-up">
                        <i class="bi bi-arrow-up"></i>
                        <span><?= number_format($overview['growth']['revenue'], 1) ?>%</span>
                        <small>vs mois dernier</small>
                    </div>
                </div>
            </div>
            <div class="kpi-footer">
                <a href="pages/finances/overview.php" class="kpi-link">
                    Voir détails <i class="bi bi-arrow-right"></i>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Charts Row -->
<div class="row g-4 mb-4">
    <!-- Revenue Chart -->
    <div class="col-xl-8">
        <div class="dashboard-card">
            <div class="card-header">
                <div class="card-header-content">
                    <h5 class="card-title">
                        <i class="bi bi-graph-up"></i>
                        Évolution des Revenus
                    </h5>
                    <p class="card-subtitle">Analyse des 6 derniers mois</p>
                </div>
                <div class="card-header-actions">
                    <div class="btn-group" role="group">
                        <button type="button" class="btn btn-sm btn-outline-secondary active">6 Mois</button>
                        <button type="button" class="btn btn-sm btn-outline-secondary">1 An</button>
                        <button type="button" class="btn btn-sm btn-outline-secondary">Tout</button>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <canvas id="revenueChart" height="80"></canvas>
            </div>
        </div>
    </div>

    <!-- Donut Chart - Distribution -->
    <div class="col-xl-4">
        <div class="dashboard-card">
            <div class="card-header">
                <div class="card-header-content">
                    <h5 class="card-title">
                        <i class="bi bi-pie-chart-fill"></i>
                        Répartition Services
                    </h5>
                    <p class="card-subtitle">Types d'interventions</p>
                </div>
            </div>
            <div class="card-body">
                <canvas id="servicesChart" height="200"></canvas>
            </div>
            <div class="card-footer">
                <div class="stats-legend">
                    <div class="legend-item">
                        <span class="legend-dot" style="background: #E1A004;"></span>
                        <span class="legend-label">Batterie</span>
                        <span class="legend-value">35%</span>
                    </div>
                    <div class="legend-item">
                        <span class="legend-dot" style="background: #10B981;"></span>
                        <span class="legend-label">Crevaison</span>
                        <span class="legend-value">28%</span>
                    </div>
                    <div class="legend-item">
                        <span class="legend-dot" style="background: #3B82F6;"></span>
                        <span class="legend-label">Panne sèche</span>
                        <span class="legend-value">22%</span>
                    </div>
                    <div class="legend-item">
                        <span class="legend-dot" style="background: #F59E0B;"></span>
                        <span class="legend-label">Autres</span>
                        <span class="legend-value">15%</span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Interventions & Top Mechanics Row -->
<div class="row g-4 mb-4">
    <!-- Recent Interventions List -->
    <div class="col-xl-8">
        <div class="dashboard-card">
            <div class="card-header">
                <div class="card-header-content">
                    <h5 class="card-title">
                        <i class="bi bi-clock-history"></i>
                        Interventions Récentes
                    </h5>
                    <p class="card-subtitle">Dernières activités de la plateforme</p>
                </div>
                <div class="card-header-actions">
                    <a href="pages/interventions/list.php" class="btn btn-sm btn-outline-primary">
                        Voir tout
                    </a>
                </div>
            </div>
            <div class="card-body">
                <div class="interventions-list">
                    <?php foreach($recentInterventions as $intervention): ?>
                    <div class="intervention-item">
                        <div class="intervention-id">
                            <span class="badge bg-dark"><?= $intervention['id'] ?></span>
                        </div>
                        <div class="intervention-client">
                            <img src="<?= getDefaultAvatar($intervention['client']) ?>" alt="" class="user-avatar-sm">
                            <div class="user-info">
                                <span class="user-label">Client</span>
                                <span class="user-name"><?= e($intervention['client']) ?></span>
                            </div>
                        </div>
                        <div class="intervention-mechanic">
                            <img src="<?= getDefaultAvatar($intervention['mechanic']) ?>" alt="" class="user-avatar-sm">
                            <div class="user-info">
                                <span class="user-label">Mécanicien</span>
                                <span class="user-name"><?= e($intervention['mechanic']) ?></span>
                            </div>
                        </div>
                        <div class="intervention-type">
                            <span class="service-badge">
                                <i class="bi bi-tools"></i>
                                <?= e($intervention['type']) ?>
                            </span>
                        </div>
                        <div class="intervention-amount">
                            <span class="amount-label">Montant</span>
                            <strong class="text-gold"><?= formatCurrency($intervention['amount']) ?></strong>
                        </div>
                        <div class="intervention-status">
                            <?= getStatusBadge($intervention['status']) ?>
                        </div>
                        <div class="intervention-date">
                            <small class="text-muted">
                                <i class="bi bi-clock"></i>
                                <?= timeAgo($intervention['created_at']) ?>
                            </small>
                        </div>
                        <div class="intervention-actions">
                            <button class="btn btn-sm btn-icon btn-outline-primary" title="Voir détails">
                                <i class="bi bi-eye"></i>
                            </button>
                            <button class="btn btn-sm btn-icon btn-outline-secondary" title="Plus d'actions">
                                <i class="bi bi-three-dots"></i>
                            </button>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Top Mechanics -->
    <div class="col-xl-4">
        <div class="dashboard-card">
            <div class="card-header">
                <div class="card-header-content">
                    <h5 class="card-title">
                        <i class="bi bi-trophy-fill"></i>
                        Top Mécaniciens
                    </h5>
                    <p class="card-subtitle">Meilleurs performers du mois</p>
                </div>
            </div>
            <div class="card-body">
                <div class="top-mechanics-list">
                    <?php foreach($topMechanics as $index => $mechanic): ?>
                    <div class="mechanic-item">
                        <div class="mechanic-rank rank-<?= $index + 1 ?>">
                            <?= $index + 1 ?>
                        </div>
                        <img src="<?= getDefaultAvatar($mechanic['name']) ?>" alt="" class="mechanic-avatar">
                        <div class="mechanic-info">
                            <h6 class="mechanic-name"><?= e($mechanic['name']) ?></h6>
                            <div class="mechanic-stats">
                                <span class="stat-item">
                                    <i class="bi bi-tools"></i>
                                    <?= $mechanic['interventions'] ?> interventions
                                </span>
                                <span class="stat-item">
                                    <i class="bi bi-star-fill text-warning"></i>
                                    <?= $mechanic['rating'] ?>
                                </span>
                            </div>
                        </div>
                        <div class="mechanic-revenue">
                            <span class="revenue-amount"><?= formatCurrency($mechanic['revenue']) ?></span>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="card-footer">
                <a href="pages/users/mechanics.php" class="btn btn-sm btn-outline-primary w-100">
                    Voir tous les mécaniciens
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Live Map & Quick Stats -->
<div class="row g-4">
    <div class="col-xl-7">
        <div class="dashboard-card">
            <div class="card-header">
                <div class="card-header-content">
                    <h5 class="card-title">
                        <i class="bi bi-geo-alt-fill"></i>
                        Carte en Temps Réel
                    </h5>
                    <p class="card-subtitle">
                        <span class="badge badge-pulse bg-success">23 interventions actives</span>
                    </p>
                </div>
                <div class="card-header-actions">
                    <a href="pages/map.php" class="btn btn-sm btn-primary">
                        Vue complète
                    </a>
                </div>
            </div>
            <div class="card-body p-0">
                <div class="map-container" id="dashboardMap" style="height: 400px; background: #0A0A0A;">
                    <!-- Google Map sera intégré ici -->
                    <div class="map-placeholder">
                        <i class="bi bi-map" style="font-size: 3rem; color: var(--text-secondary);"></i>
                        <p class="text-muted mt-3">Carte Google Maps (À intégrer)</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-5">
        <div class="dashboard-card">
            <div class="card-header">
                <div class="card-header-content">
                    <h5 class="card-title">
                        <i class="bi bi-speedometer2"></i>
                        Statistiques Rapides
                    </h5>
                </div>
            </div>
            <div class="card-body">
                <div class="quick-stats">
                    <div class="stat-row">
                        <div class="stat-icon bg-info">
                            <i class="bi bi-clock"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Temps moyen d'intervention</span>
                            <h6 class="stat-value">28 minutes</h6>
                        </div>
                    </div>

                    <div class="stat-row">
                        <div class="stat-icon bg-success">
                            <i class="bi bi-check-circle"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Taux de satisfaction</span>
                            <h6 class="stat-value">96.5%</h6>
                        </div>
                    </div>

                    <div class="stat-row">
                        <div class="stat-icon bg-warning">
                            <i class="bi bi-hourglass-split"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">En attente de mécanicien</span>
                            <h6 class="stat-value">8 demandes</h6>
                        </div>
                    </div>

                    <div class="stat-row">
                        <div class="stat-icon bg-danger">
                            <i class="bi bi-exclamation-triangle"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Litiges ouverts</span>
                            <h6 class="stat-value">2 cas</h6>
                        </div>
                    </div>

                    <div class="stat-row">
                        <div class="stat-icon bg-primary">
                            <i class="bi bi-person-check"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Mécaniciens en ligne</span>
                            <h6 class="stat-value">47 actifs</h6>
                        </div>
                    </div>

                    <div class="stat-row">
                        <div class="stat-icon bg-gold">
                            <i class="bi bi-percent"></i>
                        </div>
                        <div class="stat-content">
                            <span class="stat-label">Commission moyenne</span>
                            <h6 class="stat-value">15%</h6>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Dashboard Charts Initialization
document.addEventListener('DOMContentLoaded', function() {
    
    // ========================================
    // COUNTER ANIMATION
    // ========================================
    const counters = document.querySelectorAll('.counter');
    
    counters.forEach(counter => {
        const target = parseInt(counter.getAttribute('data-target'));
        const duration = 2000; // 2 secondes
        const increment = target / (duration / 16); // 60fps
        let current = 0;
        
        const updateCounter = () => {
            current += increment;
            if (current < target) {
                counter.textContent = Math.floor(current).toLocaleString('fr-FR');
                requestAnimationFrame(updateCounter);
            } else {
                counter.textContent = target.toLocaleString('fr-FR');
            }
        };
        
        // Démarrer l'animation après un court délai
        setTimeout(updateCounter, 300);
    });
    
    // ========================================
    // REVENUE CHART (Line Chart)
    // ========================================
    const revenueCtx = document.getElementById('revenueChart');
    if (revenueCtx) {
        const revenueData = <?= json_encode($revenueChart) ?>;
        
        new Chart(revenueCtx, {
            type: 'line',
            data: {
                labels: revenueData.labels,
                datasets: [{
                    label: 'Revenus (FCFA)',
                    data: revenueData.data,
                    borderColor: '#E1A004',
                    backgroundColor: 'rgba(225, 160, 4, 0.1)',
                    borderWidth: 3,
                    fill: true,
                    tension: 0.4,
                    pointBackgroundColor: '#E1A004',
                    pointBorderColor: '#1D1D1B',
                    pointBorderWidth: 2,
                    pointRadius: 6,
                    pointHoverRadius: 8,
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        backgroundColor: '#1A1A1A',
                        titleColor: '#E1A004',
                        bodyColor: '#FFFFFF',
                        borderColor: '#E1A004',
                        borderWidth: 1,
                        padding: 12,
                        displayColors: false,
                        callbacks: {
                            label: function(context) {
                                return context.parsed.y.toLocaleString('fr-FR') + ' FCFA';
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        ticks: {
                            color: '#A0A0A0',
                            callback: function(value) {
                                return (value / 1000000).toFixed(1) + 'M';
                            }
                        },
                        grid: {
                            color: 'rgba(255, 255, 255, 0.05)',
                            drawBorder: false
                        }
                    },
                    x: {
                        ticks: {
                            color: '#A0A0A0'
                        },
                        grid: {
                            display: false
                        }
                    }
                },
                interaction: {
                    intersect: false,
                    mode: 'index'
                }
            }
        });
    }
    
    // ========================================
    // SERVICES CHART (Doughnut Chart)
    // ========================================
    const servicesCtx = document.getElementById('servicesChart');
    if (servicesCtx) {
        new Chart(servicesCtx, {
            type: 'doughnut',
            data: {
                labels: ['Batterie', 'Crevaison', 'Panne sèche', 'Autres'],
                datasets: [{
                    data: [35, 28, 22, 15],
                    backgroundColor: [
                        '#E1A004',
                        '#10B981',
                        '#3B82F6',
                        '#F59E0B'
                    ],
                    borderWidth: 3,
                    borderColor: '#1A1A1A',
                    hoverBorderWidth: 4,
                    hoverBorderColor: '#E1A004'
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                cutout: '70%',
                plugins: {
                    legend: {
                        display: false
                    },
                    tooltip: {
                        backgroundColor: '#1A1A1A',
                        titleColor: '#E1A004',
                        bodyColor: '#FFFFFF',
                        borderColor: '#E1A004',
                        borderWidth: 1,
                        padding: 12,
                        callbacks: {
                            label: function(context) {
                                return context.label + ': ' + context.parsed + '%';
                            }
                        }
                    }
                }
            }
        });
    }
    
    // ========================================
    // KPI CARDS HOVER EFFECT
    // ========================================
    const kpiCards = document.querySelectorAll('.kpi-card');
    kpiCards.forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-8px)';
        });
        card.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
        });
    });
});

// ========================================
// QUICK ACTIONS MODAL
// ========================================
</script>

<!-- Modal: Quick Actions -->
<div class="modal fade" id="quickActionsModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <i class="bi bi-lightning-fill text-warning"></i>
                    Actions Rapides
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="row g-3">
                    <!-- Action 1: Nouveau Client -->
                    <div class="col-md-6">
                        <div class="quick-action-card" onclick="window.location.href='pages/users/clients.php'">
                            <div class="action-icon bg-primary">
                                <i class="bi bi-person-plus"></i>
                            </div>
                            <div class="action-content">
                                <h6>Nouveau Client</h6>
                                <p>Ajouter un client à la plateforme</p>
                            </div>
                            <div class="action-arrow">
                                <i class="bi bi-arrow-right"></i>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Action 2: Nouveau Mécanicien -->
                    <div class="col-md-6">
                        <div class="quick-action-card" onclick="window.location.href='pages/users/mechanics.php'">
                            <div class="action-icon bg-success">
                                <i class="bi bi-wrench"></i>
                            </div>
                            <div class="action-content">
                                <h6>Nouveau Mécanicien</h6>
                                <p>Recruter un mécanicien</p>
                            </div>
                            <div class="action-arrow">
                                <i class="bi bi-arrow-right"></i>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Action 3: Nouvelle Intervention -->
                    <div class="col-md-6">
                        <div class="quick-action-card" onclick="window.location.href='pages/interventions/list.php'">
                            <div class="action-icon bg-warning">
                                <i class="bi bi-tools"></i>
                            </div>
                            <div class="action-content">
                                <h6>Nouvelle Intervention</h6>
                                <p>Créer une intervention</p>
                            </div>
                            <div class="action-arrow">
                                <i class="bi bi-arrow-right"></i>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Action 4: Rapports -->
                    <div class="col-md-6">
                        <div class="quick-action-card" onclick="window.location.href='pages/analytics.php'">
                            <div class="action-icon bg-info">
                                <i class="bi bi-graph-up"></i>
                            </div>
                            <div class="action-content">
                                <h6>Rapports</h6>
                                <p>Voir les analyses détaillées</p>
                            </div>
                            <div class="action-arrow">
                                <i class="bi bi-arrow-right"></i>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Action 5: Messages -->
                    <div class="col-md-6">
                        <div class="quick-action-card" onclick="window.location.href='#messages'">
                            <div class="action-icon bg-secondary">
                                <i class="bi bi-chat-dots"></i>
                            </div>
                            <div class="action-content">
                                <h6>Messages</h6>
                                <p>Gérer les conversations</p>
                            </div>
                            <div class="action-arrow">
                                <i class="bi bi-arrow-right"></i>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Action 6: Paramètres -->
                    <div class="col-md-6">
                        <div class="quick-action-card" onclick="window.location.href='pages/settings.php'">
                            <div class="action-icon bg-dark">
                                <i class="bi bi-gear"></i>
                            </div>
                            <div class="action-content">
                                <h6>Paramètres</h6>
                                <p>Configuration de la plateforme</p>
                            </div>
                            <div class="action-arrow">
                                <i class="bi bi-arrow-right"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fermer</button>
            </div>
        </div>
    </div>
</div>

