<?php
require_once __DIR__ . '/../config/constants.php';
require_once __DIR__ . '/../config/functions.php';

if (!isLoggedIn() && basename($_SERVER['PHP_SELF']) != 'login.php') {
    redirect('auth/login.php');
}
?>
<!DOCTYPE html>
<html lang="fr" data-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'Dashboard' ?> | MECASOS Admin</title>
    
    <link rel="icon" href="<?= ASSETS_URL ?>img/favicon.png">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700;800&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <link href="<?= ASSETS_URL ?>css/custom.css" rel="stylesheet">
    <link href="<?= ASSETS_URL ?>css/dashboard.css" rel="stylesheet">
    
    <?php if(isset($extraCSS)): ?>
        <?php foreach($extraCSS as $css): ?>
            <link href="<?= $css ?>" rel="stylesheet">
        <?php endforeach; ?>
    <?php endif; ?>
</head>
<body>
    
    <?php include __DIR__ . '/sidebar.php'; ?>
    
    <div class="main-wrapper">
        <?php include __DIR__ . '/topbar.php'; ?>
        
        <main class="main-content">
            <?php displayFlash(); ?>
            
            <!-- Le contenu de la page est inséré ici -->
            <?php 
            if(isset($contentFile) && file_exists($contentFile)) {
                include $contentFile;
            } else {
                // Contenu par défaut si aucun fichier n'est spécifié
                echo '<div class="container-fluid">';
                if(isset($pageContent)) {
                    echo $pageContent;
                }
                echo '</div>';
            }
            ?>
        </main>
        
        <?php include __DIR__ . '/footer.php'; ?>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.js"></script>
    <script src="<?= ASSETS_URL ?>js/main.js"></script>
    
    <?php if(isset($extraJS)): ?>
        <?php foreach($extraJS as $js): ?>
            <script src="<?= $js ?>"></script>
        <?php endforeach; ?>
    <?php endif; ?>
</body>
</html>