/**
 * MECASOS Admin Dashboard - Main JavaScript
 */

document.addEventListener('DOMContentLoaded', function() {
    
    // ====================================
    // SIDEBAR FUNCTIONALITY
    // ====================================
    
    const sidebar = document.getElementById('sidebar');
    const sidebarToggle = document.getElementById('sidebarToggle');
    const sidebarOverlay = document.getElementById('sidebarOverlay');
    const menuToggle = document.getElementById('menuToggle'); // Bouton dans le header
    
    // Toggle sidebar (mobile)
    function toggleSidebar() {
        sidebar.classList.toggle('active');
        sidebarOverlay.classList.toggle('active');
        document.body.style.overflow = sidebar.classList.contains('active') ? 'hidden' : '';
    }
    
    // Toggle sidebar (desktop collapse)
    function toggleSidebarCollapse() {
        sidebar.classList.toggle('collapsed');
        localStorage.setItem('sidebarCollapsed', sidebar.classList.contains('collapsed'));
    }
    
    if (sidebarToggle) {
        sidebarToggle.addEventListener('click', toggleSidebar);
    }
     
    
    if (sidebarOverlay) {
        sidebarOverlay.addEventListener('click', toggleSidebar);
    }
    
    // Collapse toggle button (desktop only)
    const collapseToggle = document.getElementById('sidebarCollapseToggle');
    if (collapseToggle) {
        collapseToggle.addEventListener('click', toggleSidebarCollapse);
    }
 
    if (menuToggle) {
        menuToggle.addEventListener('click', toggleSidebarCollapse);
    }
    // Load saved sidebar state
    const savedCollapsed = localStorage.getItem('sidebarCollapsed');
    if (savedCollapsed === 'true' && window.innerWidth > 992) {
        sidebar.classList.add('collapsed');
    }
    
    // ====================================
    // SUBMENU TOGGLE
    // ====================================
    
    const menuItemsWithSubmenu = document.querySelectorAll('.nav-item.has-submenu');
    
    menuItemsWithSubmenu.forEach(item => {
        const wrapper = item.querySelector('.nav-item-wrapper');
        
        wrapper.addEventListener('click', function(e) {
            e.preventDefault();
            
            // Fermer les autres sous-menus
            menuItemsWithSubmenu.forEach(otherItem => {
                if (otherItem !== item) {
                    otherItem.classList.remove('active');
                }
            });
            
            // Toggle le sous-menu actuel
            item.classList.toggle('active');
        });
    });
    
    // ====================================
    // GLOBAL SEARCH (Ctrl+K / Cmd+K)
    // ====================================
    
    const globalSearch = document.getElementById('globalSearch');
    
    document.addEventListener('keydown', function(e) {
        // Ctrl+K ou Cmd+K
        if ((e.ctrlKey || e.metaKey) && e.key === 'k') {
            e.preventDefault();
            globalSearch.focus();
        }
        
        // Escape pour fermer
        if (e.key === 'Escape') {
            globalSearch.blur();
        }
    });
    
    // Recherche en temps réel (à implémenter avec backend)
    if (globalSearch) {
        let searchTimeout;
        globalSearch.addEventListener('input', function() {
            clearTimeout(searchTimeout);
            const query = this.value.trim();
            
            if (query.length >= 2) {
                searchTimeout = setTimeout(() => {
                    performSearch(query);
                }, 300);
            }
        });
    }
    
    function performSearch(query) {
        console.log('Recherche:', query);
        // TODO: Implémenter avec AJAX
        // Afficher un dropdown avec résultats
    }
    
    // ====================================
    // THEME TOGGLE
    // ====================================
    
    const themeToggle = document.getElementById('themeToggle');
    const currentTheme = localStorage.getItem('theme') || 'dark';
    
    // Appliquer le thème sauvegardé
    document.documentElement.setAttribute('data-theme', currentTheme);
    updateThemeIcon(currentTheme);
    
    if (themeToggle) {
        themeToggle.addEventListener('click', function() {
            const currentTheme = document.documentElement.getAttribute('data-theme');
            const newTheme = currentTheme === 'dark' ? 'light' : 'dark';
            
            document.documentElement.setAttribute('data-theme', newTheme);
            localStorage.setItem('theme', newTheme);
            updateThemeIcon(newTheme);
            
            // Animation
            this.style.transform = 'rotate(360deg)';
            setTimeout(() => {
                this.style.transform = 'rotate(0deg)';
            }, 300);
        });
    }
    
    function updateThemeIcon(theme) {
        const icon = themeToggle.querySelector('i');
        if (theme === 'dark') {
            icon.className = 'bi bi-moon-stars-fill';
        } else {
            icon.className = 'bi bi-sun-fill';
        }
    }
    
    // ====================================
    // ACTIVE SUBMENU AUTO-OPEN
    // ====================================
    
    // Si une page du sous-menu est active, ouvrir le sous-menu parent
    const activeSubitem = document.querySelector('.nav-subitem.active');
    if (activeSubitem) {
        const parentSubmenu = activeSubitem.closest('.nav-item.has-submenu');
        if (parentSubmenu) {
            parentSubmenu.classList.add('active');
        }
    }
    
    // ====================================
    // SMOOTH SCROLL
    // ====================================
    
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function(e) {
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                e.preventDefault();
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
    
    // ====================================
    // RESPONSIVE HANDLING
    // ====================================
    
    function handleResize() {
        if (window.innerWidth > 992) {
            sidebar.classList.remove('active');
            sidebarOverlay.classList.remove('active');
            document.body.style.overflow = '';
        }
    }
    
    window.addEventListener('resize', handleResize);
    
    // ====================================
    // DROPDOWN MANAGEMENT
    // ====================================
    
    // Fonction pour fermer tous les dropdowns
    function closeAllDropdowns() {
        const openDropdowns = document.querySelectorAll('.dropdown.show, .dropdown-menu.show');
        openDropdowns.forEach(dropdown => {
            if (dropdown.classList.contains('dropdown')) {
                dropdown.classList.remove('show');
                const button = dropdown.querySelector('[data-bs-toggle="dropdown"]');
                if (button) {
                    button.setAttribute('aria-expanded', 'false');
                }
            } else if (dropdown.classList.contains('dropdown-menu')) {
                dropdown.classList.remove('show');
                const parentDropdown = dropdown.closest('.dropdown');
                if (parentDropdown) {
                    parentDropdown.classList.remove('show');
                    const button = parentDropdown.querySelector('[data-bs-toggle="dropdown"]');
                    if (button) {
                        button.setAttribute('aria-expanded', 'false');
                    }
                }
            }
        });
    }
    
    // Fermer dropdowns en cliquant à l'extérieur
    document.addEventListener('click', function(e) {
        const clickedElement = e.target;
        const isDropdownToggle = clickedElement.hasAttribute('data-bs-toggle');
        const isDropdownMenu = clickedElement.closest('.dropdown-menu');
        
        if (!isDropdownToggle && !isDropdownMenu) {
            // Attendre un peu pour laisser Bootstrap gérer sa propre logique
            setTimeout(() => {
                const openDropdowns = document.querySelectorAll('.dropdown.show');
                openDropdowns.forEach(dropdown => {
                    if (!dropdown.contains(clickedElement)) {
                        dropdown.classList.remove('show');
                        const button = dropdown.querySelector('[data-bs-toggle="dropdown"]');
                        if (button) {
                            button.setAttribute('aria-expanded', 'false');
                        }
                    }
                });
            }, 10);
        }
    });
    
    // Fermer dropdowns avec la touche Escape
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            closeAllDropdowns();
            
            // Également fermer la sidebar si elle est ouverte (mobile)
            if (sidebar && sidebar.classList.contains('active')) {
                toggleSidebar();
            }
        }
    });
    
    // Gérer l'ouverture/fermeture des dropdowns Bootstrap
    const dropdownToggles = document.querySelectorAll('[data-bs-toggle="dropdown"]');
    dropdownToggles.forEach(toggle => {
        toggle.addEventListener('click', function(e) {
            e.stopPropagation();
            
            const dropdown = this.closest('.dropdown');
            const dropdownMenu = dropdown.querySelector('.dropdown-menu');
            
            // Fermer les autres dropdowns
            closeAllDropdowns();
            
            // Toggle le dropdown actuel
            if (!dropdown.classList.contains('show')) {
                dropdown.classList.add('show');
                this.setAttribute('aria-expanded', 'true');
                dropdownMenu.classList.add('show');
            }
        });
    });
    
    // ====================================
    // NOTIFICATIONS BADGE ANIMATION
    // ====================================
    
    const badges = document.querySelectorAll('.nav-badge');
    badges.forEach(badge => {
        // Animation au chargement
        badge.style.opacity = '0';
        badge.style.transform = 'scale(0)';
        
        setTimeout(() => {
            badge.style.transition = 'all 0.4s cubic-bezier(0.68, -0.55, 0.265, 1.55)';
            badge.style.opacity = '1';
            badge.style.transform = 'scale(1)';
        }, 300);
    });
    
    // ====================================
    // CONSOLE BRANDING
    // ====================================
    
    console.log('%c MECASOS Admin Dashboard ', 'background: #E1A004; color: #1D1D1B; font-size: 20px; font-weight: bold; padding: 10px;');
    console.log('%c Développé avec ❤️ pour l\'excellence ', 'color: #E1A004; font-size: 12px;');
});