<?php
/**
 * Main API Router
 * 
 * Routes requests to appropriate API endpoints
 */

require_once __DIR__ . '/cors.php';

// Get request URI and remove query string
$requestUri = strtok($_SERVER['REQUEST_URI'], '?');

// Remove /api prefix if present
$requestUri = preg_replace('#^/api#', '', $requestUri);

// Route to appropriate endpoint
if (preg_match('#^/auth#', $requestUri)) {
    require __DIR__ . '/api/auth.php';
} 
elseif (preg_match('#^/users#', $requestUri)) {
    require __DIR__ . '/api/users.php';
} 
elseif (preg_match('#^/vehicles#', $requestUri)) {
    require __DIR__ . '/api/vehicles.php';
} 
elseif (preg_match('#^/requests#', $requestUri)) {
    require __DIR__ . '/api/requests.php';
} 
elseif (preg_match('#^/reviews#', $requestUri)) {
    require __DIR__ . '/api/reviews.php';
} 
elseif (preg_match('#^/wallet#', $requestUri)) {
    require __DIR__ . '/api/wallet.php';
} 
else {
    header('Content-Type: application/json');
    http_response_code(200);
    echo json_encode([
        'success' => true,
        'message' => 'MECASOS API',
        'version' => '1.0.0',
        'endpoints' => [
            'POST /api/auth/register' => 'Register new user',
            'POST /api/auth/login' => 'Login user',
            'POST /api/auth/logout' => 'Logout user',
            'POST /api/auth/forgot-password' => 'Request password reset',
            'GET /api/auth/me' => 'Get current user',
            'GET /api/users' => 'Get users list',
            'GET /api/users/:id' => 'Get user by ID',
            'PUT /api/users/:id' => 'Update user',
            'GET /api/users/nearby' => 'Get nearby mechanics',
            'GET /api/vehicles' => 'Get user vehicles',
            'POST /api/vehicles' => 'Create vehicle',
            'PUT /api/vehicles/:id' => 'Update vehicle',
            'DELETE /api/vehicles/:id' => 'Delete vehicle',
            'GET /api/requests' => 'Get breakdown requests',
            'POST /api/requests' => 'Create breakdown request',
            'PUT /api/requests/:id/accept' => 'Accept request (mechanic)',
            'PUT /api/requests/:id/status' => 'Update request status',
            'DELETE /api/requests/:id' => 'Cancel request',
            'GET /api/reviews' => 'Get reviews',
            'POST /api/reviews' => 'Create review',
            'PUT /api/reviews/:id' => 'Update review',
            'DELETE /api/reviews/:id' => 'Delete review',
            'GET /api/wallet' => 'Get wallet balance',
            'POST /api/wallet/topup' => 'Top up wallet',
            'GET /api/wallet/transactions' => 'Get transactions'
        ]
    ]);
}
